#include "SimulationEngineEncoderDecoder.h"


namespace SimulationEngine
{

SimulationEngineEncoderDecoder *SimulationEngineEncoderDecoder::instance = 0;

SimulationEngineEncoderDecoder::SimulationEngineEncoderDecoder()
{
	conf= ConfigurationServer::GetInstance();
}

SimulationEngineEncoderDecoder *SimulationEngineEncoderDecoder::GetInstance()
{
	if (instance==0)
		instance =  new SimulationEngineEncoderDecoder();
	return instance;
}

DataRequest * SimulationEngineEncoderDecoder::DecodeEntity(XMLNode entityrequestnode)
{
	if (strcmp(entityrequestnode.getAttribute("Command"),conf->GetCommandRobotControlKey().data())==0)
	{
		bool response = false;
		string commandkey = conf->GetCommandRobotControlKey();
		list<DataParameter *> vels;
		int identity =atoi(entityrequestnode.getChildNode("Entity_Id").getText());
		XMLNode motorsnode = entityrequestnode.getChildNode("Motors");
		int childnumber = 0;
		while (!motorsnode.getChildNode(childnumber).isEmpty())
		{
			XMLNode currentwheel = motorsnode.getChildNode(childnumber);
			int wheelid = atoi(currentwheel.getChildNode("Wheel_Joint_Id").getText());
			float velvalue = atof(currentwheel.getChildNode("Value").getText());
			vels.push_back(new DataWheelJointVelocity(wheelid, velvalue));
			childnumber++;
		}
		return new DataEntityRequest(response, vels, identity, commandkey);
		
	}
	else if (strcmp(entityrequestnode.getAttribute("Command"),conf->GetCommandSetEntityPositionKey().data())==0)
	{
		int identity =atoi(entityrequestnode.getChildNode("Entity_Id").getText());
		float pos_x = atof(entityrequestnode.getChildNode("Position_X").getText());
		float pos_y = atof(entityrequestnode.getChildNode("Position_Y").getText());
		float pos_z = atof(entityrequestnode.getChildNode("Position_Z").getText());
		list<DataParameter *> pars;
		pars.push_back(new Vector3f(pos_x, pos_y, pos_z));
		return new DataEntityRequest(false, pars, identity, conf->GetCommandSetEntityPositionKey());
		
	}
	DataRequest *dr=0;
	return dr;
}


DataRequest * SimulationEngineEncoderDecoder::DecodeRobot(XMLNode robot)
{
	bool response;
	DataRobot *datarobot;
	string commandkey = conf->GetCommandCreateEntityKey();
	XMLNode auxnode = robot.getChildNode("Response");
	if (auxnode.isEmpty())
		response = conf->GetDefaultResponseRequest();
	else
	{
		if (strcmp(auxnode.getText(),"true")==0)
			response = true;
		else
			response = false;
	}
	XMLNode datanode = robot.getChildNode("Data");

	XMLNode entityidnode = datanode.getChildNode("Entity_id");
	int entityid = atoi(entityidnode.getText());
	
	XMLNode structure = datanode.getChildNode("Structure");
	int childnumber=0;
	list<DataObject *> objects;
	while (!structure.getChildNode(childnumber).isEmpty())
	{
		XMLNode currentobj = structure.getChildNode(childnumber);
		DataObject *object=0;
		if (strcmp(currentobj.getName(), "Joint")==0)
		{
			XMLNode jointidnode = currentobj.getChildNode("Joint_id");
			int jointid = atoi(jointidnode.getText());
			XMLNode body1node = currentobj.getChildNode("Body_1");
			int body1 = atoi(body1node.getText());
			XMLNode body2node = currentobj.getChildNode("Body_2");
			int body2 = atoi(body2node.getText());
			if (strcmp(currentobj.getAttribute("Type"), "WheelJoint")==0)
			{				
				Vector3f axis1;
				XMLNode axis1_x_node = currentobj.getChildNode("Axis_1_X");
				axis1.SetFirst(atof(axis1_x_node.getText()));
				XMLNode axis1_y_node = currentobj.getChildNode("Axis_1_Y");
				axis1.SetSecond(atof(axis1_y_node.getText()));
				XMLNode axis1_z_node = currentobj.getChildNode("Axis_1_Z");
				axis1.SetThird(atof(axis1_z_node.getText()));
				Vector3f axis2;
				XMLNode axis2_x_node = currentobj.getChildNode("Axis_2_X");
				axis2.SetFirst(atof(axis2_x_node.getText()));
				XMLNode axis2_y_node = currentobj.getChildNode("Axis_2_Y");
				axis2.SetSecond(atof(axis2_y_node.getText()));
				XMLNode axis2_z_node = currentobj.getChildNode("Axis_2_Z");
				axis2.SetThird(atof(axis2_z_node.getText()));
				XMLNode hardnessnode = currentobj.getChildNode("Hardness");
				float hardness;
				if (hardnessnode.isEmpty())
					hardness = conf->GetDefaultWheelJointHardness();
				else	
					hardness= atof(hardnessnode.getText());
				XMLNode bouncinessnode = currentobj.getChildNode("Bounciness");
				float bounciness;
				if (bouncinessnode.isEmpty())
					bounciness = conf->GetDefaultWheelJointBounciness();
				else	
					bounciness= atof(bouncinessnode.getText());
				XMLNode maxtorquenode = currentobj.getChildNode("Maximum_Torque");
				float maxtorque;
				if (maxtorquenode.isEmpty())
					maxtorque = conf->GetDefaultWheelJointMaxTorque();
				else	
					maxtorque= atof(maxtorquenode.getText());
				object = new DataWheelJoint(jointid, body1, body2, axis1, axis2, hardness, bounciness, maxtorque, 0);
				
				
			}
			else if (strcmp(currentobj.getAttribute("Type"), "FixedJoint")==0)
			{
				object = new DataFixedJoint(jointid, body1, body2);
			}
		}
		else if (strcmp(currentobj.getName(), "Body")==0)
		{
			XMLNode bodyidnode = currentobj.getChildNode("Body_id");
			int bodyid = atoi(bodyidnode.getText());
			int bodymaterial;
			XMLNode bodymaterialnode = currentobj.getChildNode("Material");
			if (bodymaterialnode.isEmpty())
				bodymaterial = conf->GetDefaultBodyMaterial();
			else	
				bodymaterial = atoi(bodymaterialnode.getText());
			
			float bodymass;
			XMLNode bodymassnode = currentobj.getChildNode("Mass");
			if (bodymassnode.isEmpty())
				bodymass = conf->GetDefaultBodyMass();
			else	
				bodymass = atof(bodymassnode.getText());
			
			Vector3f position;
			XMLNode position_x_node = currentobj.getChildNode("Position_X");
			position.SetFirst(atof(position_x_node.getText()));
			XMLNode position_y_node = currentobj.getChildNode("Position_Y");
			position.SetSecond(atof(position_y_node.getText()));
			XMLNode position_z_node = currentobj.getChildNode("Position_Z");
			position.SetThird(atof(position_z_node.getText()));
			
			Vector3f rotation;
			XMLNode rotation_x_node = currentobj.getChildNode("Rotation_X");
			rotation.SetFirst(atof(rotation_x_node.getText()));
			XMLNode rotation_y_node = currentobj.getChildNode("Rotation_Y");
			rotation.SetSecond(atof(rotation_y_node.getText()));
			XMLNode rotation_z_node = currentobj.getChildNode("Rotation_Z");
			rotation.SetThird(atof(rotation_z_node.getText()));
			
			if (strcmp(currentobj.getAttribute("Type"), "Box")==0)
			{				
				Vector3f size;
				XMLNode size_x_node = currentobj.getChildNode("Size_X");
				size.SetFirst(atof(size_x_node.getText()));
				XMLNode size_y_node = currentobj.getChildNode("Size_Y");
				size.SetSecond(atof(size_y_node.getText()));
				XMLNode size_z_node = currentobj.getChildNode("Size_Z");
				size.SetThird(atof(size_z_node.getText()));
				object = new DataBox(bodyid, size, position, rotation, bodymaterial, bodymass, Vector3f(0,0,0),Vector3f(0,0,0));
			}
			else if (strcmp(currentobj.getAttribute("Type"), "Sphere")==0)
			{
				XMLNode radiusnode = currentobj.getChildNode("Radius");
				float radius = atof(radiusnode.getText());
				object = new DataSphere(bodyid, radius, position, rotation, bodymaterial, bodymass, Vector3f(0,0,0),Vector3f(0,0,0));
			}
			else if (strcmp(currentobj.getAttribute("Type"), "WheelCylinder")==0)
			{
				XMLNode radiusnode = currentobj.getChildNode("Radius");
				float radius = atof(radiusnode.getText());
				XMLNode lengthnode = currentobj.getChildNode("Length");
				float length = atof(lengthnode.getText());
				object = new DataWheelCylinder(bodyid, radius, length, position, rotation, bodymaterial, bodymass, Vector3f(0,0,0),Vector3f(0,0,0));
			}
			else if (strcmp(currentobj.getAttribute("Type"), "Cylinder")==0)
			{
				XMLNode radiusnode = currentobj.getChildNode("Radius");
				float radius = atof(radiusnode.getText());
				XMLNode lengthnode = currentobj.getChildNode("Length");
				float length = atof(lengthnode.getText());
				object = new DataCylinder(bodyid, radius, length, position, rotation, bodymaterial, bodymass, Vector3f(0,0,0),Vector3f(0,0,0));
			}
		}		
		objects.push_back(object);
		childnumber++;
	}
	
	list<int> motors;
	XMLNode motorsnode = datanode.getChildNode("Motors"); 
	if (!motorsnode.isEmpty())
	{
		childnumber = 0;
		while (!motorsnode.getChildNode(childnumber).isEmpty())
		{
			XMLNode currentmotor = motorsnode.getChildNode(childnumber);
			int motornumber = atoi(currentmotor.getText());
			motors.push_back(motornumber);
			childnumber++;
		}
	}
	
	XMLNode refbodynode = datanode.getChildNode("Reference_Body");
	int refbody = atoi(refbodynode.getText());
	
	datarobot =  new DataRobot(entityid, objects, motors, refbody);
	list <DataParameter *> pars;
	pars.push_back(datarobot);
	return new DataControlRequest(response, pars, commandkey);
}

DataRequest * SimulationEngineEncoderDecoder::DecodeField(XMLNode field)
{
	bool response;
	DataField *datafield;
	string commandkey = conf->GetCommandCreateEntityKey();
	XMLNode auxnode = field.getChildNode("Response");
	if (auxnode.isEmpty())
		response = conf->GetDefaultResponseRequest();
	else
	{
		if (strcmp(auxnode.getText(),"true")==0)
			response = true;
		else
			response = false;
	}
	XMLNode datanode = field.getChildNode("Data");

	XMLNode entityidnode = datanode.getChildNode("Entity_id");
	int entityid = atoi(entityidnode.getText());
	
	XMLNode structure = datanode.getChildNode("Structure");
	int childnumber=0;
	
	list<DataBody *> objects;
	while (!structure.getChildNode(childnumber).isEmpty())
	{
		XMLNode currentobj = structure.getChildNode(childnumber);
		DataBody *object=0;	
		if (strcmp(currentobj.getName(), "Body")==0)
		{
			XMLNode bodyidnode = currentobj.getChildNode("Body_id");
			int bodyid = atoi(bodyidnode.getText());
			int bodymaterial;
			XMLNode bodymaterialnode = currentobj.getChildNode("Material");
			if (bodymaterialnode.isEmpty())
				bodymaterial = conf->GetDefaultBodyMaterial();
			else	
				bodymaterial = atoi(bodymaterialnode.getText());
			
			float bodymass;
			XMLNode bodymassnode = currentobj.getChildNode("Mass");
			if (bodymassnode.isEmpty())
				bodymass = conf->GetDefaultBodyMass();
			else	
				bodymass = atof(bodymassnode.getText());
			
			Vector3f position;
			XMLNode position_x_node = currentobj.getChildNode("Position_X");
			position.SetFirst(atof(position_x_node.getText()));
			XMLNode position_y_node = currentobj.getChildNode("Position_Y");
			position.SetSecond(atof(position_y_node.getText()));
			XMLNode position_z_node = currentobj.getChildNode("Position_Z");
			position.SetThird(atof(position_z_node.getText()));
			
			Vector3f rotation;
			XMLNode rotation_x_node = currentobj.getChildNode("Rotation_X");
			rotation.SetFirst(atof(rotation_x_node.getText()));
			XMLNode rotation_y_node = currentobj.getChildNode("Rotation_Y");
			rotation.SetSecond(atof(rotation_y_node.getText()));
			XMLNode rotation_z_node = currentobj.getChildNode("Rotation_Z");
			rotation.SetThird(atof(rotation_z_node.getText()));
			
			if (strcmp(currentobj.getAttribute("Type"), "Box")==0)
			{
				Vector3f size;
				XMLNode size_x_node = currentobj.getChildNode("Size_X");
				size.SetFirst(atof(size_x_node.getText()));
				XMLNode size_y_node = currentobj.getChildNode("Size_Y");
				size.SetSecond(atof(size_y_node.getText()));
				XMLNode size_z_node = currentobj.getChildNode("Size_Z");
				size.SetThird(atof(size_z_node.getText()));
				object = new DataBox(bodyid, size, position, rotation, bodymaterial, bodymass, Vector3f(0,0,0),Vector3f(0,0,0));
			}
			else if (strcmp(currentobj.getAttribute("Type"), "Sphere")==0)
			{
				XMLNode radiusnode = currentobj.getChildNode("Radius");
				float radius = atof(radiusnode.getText());
				object = new DataSphere(bodyid, radius, position, rotation, bodymaterial, bodymass, Vector3f(0,0,0),Vector3f(0,0,0));
			}
			else if (strcmp(currentobj.getAttribute("Type"), "WheelCylinder")==0)
			{
				XMLNode radiusnode = currentobj.getChildNode("Radius");
				float radius = atof(radiusnode.getText());
				XMLNode lengthnode = currentobj.getChildNode("Length");
				float length = atof(lengthnode.getText());
				object = new DataWheelCylinder(bodyid, radius, length, position, rotation, bodymaterial, bodymass, Vector3f(0,0,0),Vector3f(0,0,0));
			}
			else if (strcmp(currentobj.getAttribute("Type"), "Cylinder")==0)
			{
				XMLNode radiusnode = currentobj.getChildNode("Radius");
				float radius = atof(radiusnode.getText());
				XMLNode lengthnode = currentobj.getChildNode("Length");
				float length = atof(lengthnode.getText());
				object = new DataCylinder(bodyid, radius, length, position, rotation, bodymaterial, bodymass, Vector3f(0,0,0),Vector3f(0,0,0));
			}
		}		
		objects.push_back(object);
		childnumber++;
	}
	
	datafield = new DataField(entityid, objects);
	list <DataParameter *> pars;
	pars.push_back(datafield);
	return new DataControlRequest(response, pars, commandkey);
		
}

DataRequest * SimulationEngineEncoderDecoder::DecodeBall(XMLNode ball)
{
	bool response;
	DataBall *databall;
	string commandkey = conf->GetCommandCreateEntityKey();
	XMLNode auxnode = ball.getChildNode("Response");
	if (auxnode.isEmpty())
		response = conf->GetDefaultResponseRequest();
	else
	{
		if (strcmp(auxnode.getText(),"true")==0)
			response = true;
		else
			response = false;
	}
	XMLNode datanode = ball.getChildNode("Data");

	XMLNode entityidnode = datanode.getChildNode("Entity_id");
	int entityid = atoi(entityidnode.getText());
	/*XMLNode bodyidnode = datanode.getChildNode("Body_id");
	int bodyid = atoi(bodyidnode.getText());*/
	int bodymaterial;
	XMLNode bodymaterialnode = datanode.getChildNode("Material");
	if (bodymaterialnode.isEmpty())
		bodymaterial = conf->GetDefaultBodyMaterial();
	else	
		bodymaterial = atoi(bodymaterialnode.getText());
	
	float bodymass;
	XMLNode bodymassnode = datanode.getChildNode("Mass");
	if (bodymassnode.isEmpty())
		bodymass = conf->GetDefaultBodyMass();
	else	
		bodymass = atof(bodymassnode.getText());
	
	Vector3f position;
	XMLNode position_x_node = datanode.getChildNode("Position_X");
	position.SetFirst(atof(position_x_node.getText()));
	XMLNode position_y_node = datanode.getChildNode("Position_Y");
	position.SetSecond(atof(position_y_node.getText()));
	XMLNode position_z_node = datanode.getChildNode("Position_Z");
	position.SetThird(atof(position_z_node.getText()));
	
	Vector3f rotation;
	XMLNode rotation_x_node = datanode.getChildNode("Rotation_X");
	rotation.SetFirst(atof(rotation_x_node.getText()));
	XMLNode rotation_y_node = datanode.getChildNode("Rotation_Y");
	rotation.SetSecond(atof(rotation_y_node.getText()));
	XMLNode rotation_z_node = datanode.getChildNode("Rotation_Z");
	rotation.SetThird(atof(rotation_z_node.getText()));
	XMLNode radiusnode = datanode.getChildNode("Radius");
	float radius = atof(radiusnode.getText());
	
	databall = new DataBall(entityid, bodymaterial, bodymass, position, radius, rotation, Vector3f(0,0,0), Vector3f(0,0,0));
	list <DataParameter *> pars;
	pars.push_back(databall);
	return new DataControlRequest(response, pars, commandkey);
}

DataRequest * SimulationEngineEncoderDecoder::DecodeControl(XMLNode controlrequestnode)
{
	if (strcmp(controlrequestnode.getAttribute("Command"),conf->GetCommandCreateEntityKey().data())==0)
	{
		if (strcmp(controlrequestnode.getAttribute("Type"),"Robot")==0)
		{
			return DecodeRobot(controlrequestnode);
		}
		else if (strcmp(controlrequestnode.getAttribute("Type"),"Field")==0)
		{
			return DecodeField(controlrequestnode);
		}
		else if (strcmp(controlrequestnode.getAttribute("Type"),"Ball")==0)
		{
			return DecodeBall(controlrequestnode);
		}
		else
		{
			DataRequest *dr=0;
			return dr;
		}
	}
	else
	{
		bool response;
		XMLNode auxnode = controlrequestnode.getChildNode("Response");
		if (auxnode.isEmpty())
			response = conf->GetDefaultResponseRequest();
		else
		{
			if (strcmp(auxnode.getText(),"true")==0)
				response = true;
			else
				response = false;
		}
		if (strcmp(controlrequestnode.getAttribute("Command"),conf->GetCommandInitializeSimulationKey().data())==0)
		{
			list <DataParameter *> pars;
			pars.push_back(new DataBool(true));
			return new DataControlRequest(response, pars, conf->GetCommandInitializeSimulationKey());
		}
		else if (strcmp(controlrequestnode.getAttribute("Command"),conf->GetCommandSetStepModeKey().data())==0)
		{
			list <DataParameter *> pars;
			XMLNode stepmodenode = controlrequestnode.getChildNode("Step_Mode");
			bool stepmode;
			if (strcmp(stepmodenode.getText(),"true")==0)
				stepmode = true;
			else
				stepmode = false;
			pars.push_back(new DataBool(stepmode));
			return new DataControlRequest(response, pars, conf->GetCommandSetStepModeKey());
		}
		else if (strcmp(controlrequestnode.getAttribute("Command"),conf->GetCommandSetStepFlagKey().data())==0)
		{
			list <DataParameter *> pars;
			pars.push_back(new DataBool(true));
			return new DataControlRequest(response, pars, conf->GetCommandSetStepFlagKey());
		}
		else if (strcmp(controlrequestnode.getAttribute("Command"),conf->GetCommandSetTimeStepKey().data())==0)
		{
			list <DataParameter *> pars;
			XMLNode bodytimestep = controlrequestnode.getChildNode("Timestep");
			float timestep = atof(bodytimestep.getText());
			pars.push_back(new DataFloat(timestep));
			return new DataControlRequest(response, pars, conf->GetCommandSetTimeStepKey());
		}
		else if (strcmp(controlrequestnode.getAttribute("Command"),conf->GetCommandSetSyncModeKey().data())==0)
		{
			list <DataParameter *> pars;
			XMLNode syncmodenode = controlrequestnode.getChildNode("Sync_Mode");
			bool syncmode = false;
			if (strcmp(syncmodenode.getText(),"true")==0)
			{
				syncmode = true;
			}
			pars.push_back(new DataBool(syncmode));
			return new DataControlRequest(response, pars, conf->GetCommandSetSyncModeKey());
		}
		else if (strcmp(controlrequestnode.getAttribute("Command"),conf->GetCommandSynchronizeKey().data())==0)
		{
			list <DataParameter *> pars;
			XMLNode iterationnode = controlrequestnode.getChildNode("Iteration");
			int iteration = atoi(iterationnode.getText());
			pars.push_back(new DataInteger(iteration));
			return new DataControlRequest(response, pars, conf->GetCommandSynchronizeKey());
		}
		else if (strcmp(controlrequestnode.getAttribute("Command"),conf->GetCommandSetSyncWaitKey().data())==0)
		{
			list <DataParameter *> pars;
			XMLNode syncwaitnode = controlrequestnode.getChildNode("Sync_Wait");
			char *endptr;
			double syncwait = strtod(syncwaitnode.getText(), &endptr);
			pars.push_back(new DataDouble(syncwait));
			return new DataControlRequest(response, pars, conf->GetCommandSetSyncWaitKey());
		}
		else if (strcmp(controlrequestnode.getAttribute("Command"),conf->GetCommandSaveToFileKey().data())==0)
		{		
			list <DataParameter *> pars;
			XMLNode filenode = controlrequestnode.getChildNode("File");
			string filename = filenode.getText();
			pars.push_back(new DataString(filename));
			return new DataControlRequest(response, pars, conf->GetCommandSaveToFileKey());
		}
		else if (strcmp(controlrequestnode.getAttribute("Command"),conf->GetCommandLoadFromFileKey().data())==0)
		{		
			list <DataParameter *> pars;
			XMLNode filenode = controlrequestnode.getChildNode("File");
			string filename = filenode.getText();
			pars.push_back(new DataString(filename));
			return new DataControlRequest(response, pars, conf->GetCommandLoadFromFileKey());
		}
		else if (strcmp(controlrequestnode.getAttribute("Command"),conf->GetCommandSetWorldBouncinessKey().data())==0)
		{
			list <DataParameter *> pars;
			XMLNode bouncinessnode = controlrequestnode.getChildNode("Bounciness");
			float bounciness = atof(bouncinessnode.getText());
			pars.push_back(new DataFloat(bounciness));
			return new DataControlRequest(response, pars, conf->GetCommandSetWorldBouncinessKey());
		}
		else if (strcmp(controlrequestnode.getAttribute("Command"),conf->GetCommandSetWorldHardnessKey().data())==0)
		{
			list <DataParameter *> pars;
			XMLNode hardnessnode = controlrequestnode.getChildNode("Hardness");
			float hardness = atof(hardnessnode.getText());
			pars.push_back(new DataFloat(hardness));
			return new DataControlRequest(response, pars, conf->GetCommandSetWorldHardnessKey());
		}
		else if (strcmp(controlrequestnode.getAttribute("Command"),conf->GetCommandSetWorldGravityKey().data())==0)
		{
			list <DataParameter *> pars;
			float gravx=0,gravy=0,gravz=0;
			XMLNode gravxnode = controlrequestnode.getChildNode("Gravity_X");
			if (!gravxnode.isEmpty())
				gravx = atof(gravxnode.getText());
			XMLNode gravynode = controlrequestnode.getChildNode("Gravity_Y");
			if (!gravynode.isEmpty())
				gravy = atof(gravynode.getText());
			XMLNode gravznode = controlrequestnode.getChildNode("Gravity_Z");
			if (!gravznode.isEmpty())
				gravz = atof(gravznode.getText());
			XMLNode gravznode2 = controlrequestnode.getChildNode("Gravity");
			if (!gravznode2.isEmpty())
				gravz = atof(gravznode2.getText());
			pars.push_back(new Vector3f(gravx,gravy,gravz));
			return new DataControlRequest(response, pars, conf->GetCommandSetWorldGravityKey());
		}
		else if (strcmp(controlrequestnode.getAttribute("Command"),conf->GetCommandRegisterMaterialsInteractionsKey().data())==0)
		{
			list <DataParameter *> pars;
			int childnumber=0;
				
			while (!controlrequestnode.getChildNode(childnumber).isEmpty())
			{
				XMLNode child = controlrequestnode.getChildNode(childnumber);
				if (strcmp(child.getName(),"Material")==0)
				{
					int matid = atoi(child.getChildNode("Material_Id").getText());
					string matname = "";
					if (!child.getChildNode("Material_Name").isEmpty())
						matname = child.getChildNode("Material_Name").getText();
					pars.push_back(new DataMaterial(matid,matname));
				}
				else if (strcmp(child.getName(),"Interaction")==0)
				{
					int mat1id = atoi(child.getChildNode("Material_1").getText());
					int mat2id = atoi(child.getChildNode("Material_2").getText());
					float hardness;
					if (!child.getChildNode("Hardness").isEmpty())
						hardness = atof(child.getChildNode("Hardness").getText());
					else
						hardness = ConfigurationServer::GetInstance()->GetDefaultHardnessInteraction();
					float bounciness;
					if (!child.getChildNode("Bounciness").isEmpty())
						bounciness = atof(child.getChildNode("Bounciness").getText());
					else
						bounciness = ConfigurationServer::GetInstance()->GetDefaultBouncinessInteraction();
					float slip1;
					if (!child.getChildNode("Slip1").isEmpty())
						slip1 = atof(child.getChildNode("Slip1").getText());
					else
						slip1 = ConfigurationServer::GetInstance()->GetDefaultSlip1Interaction();
					float slip2;
					if (!child.getChildNode("Slip2").isEmpty())
						slip2 = atof(child.getChildNode("Slip2").getText());
					else
						slip2 = ConfigurationServer::GetInstance()->GetDefaultSlip2Interaction();
					float friction;
					if (!child.getChildNode("Friction").isEmpty())
						friction = atof(child.getChildNode("Friction").getText());
					else
						friction = ConfigurationServer::GetInstance()->GetDefaultFrictionInteraction();
					DataInteraction datainteract(hardness,bounciness,slip1,slip2,friction);
					pars.push_back(new DataMaterialInteraction(mat1id,mat2id, datainteract));
				}
				childnumber++;
			}
			
			return new DataControlRequest(response, pars, conf->GetCommandRegisterMaterialsInteractionsKey());
		}
		else if (strcmp(controlrequestnode.getAttribute("Command"),conf->GetCommandStepsPerIterationKey().data())==0)
		{
			list <DataParameter *> pars;
			XMLNode stepsnode = controlrequestnode.getChildNode("Steps_Per_Iteration");
			int steps = atoi(stepsnode.getText());
			pars.push_back(new DataInteger(steps));
			return new DataControlRequest(response, pars, conf->GetCommandStepsPerIterationKey());
		}
		else if (strcmp(controlrequestnode.getAttribute("Command"),conf->GetCommandSetFastModeKey().data())==0)
		{
			list <DataParameter *> pars;
			XMLNode fastmodenode = controlrequestnode.getChildNode("Fast_Mode");
			bool fastmode;
			if (strcmp(fastmodenode.getText(),"true")==0)
				fastmode = true;
			else
				fastmode = false;
			pars.push_back(new DataBool(fastmode));
			return new DataControlRequest(response, pars, conf->GetCommandSetFastModeKey());
		}
		else if (strcmp(controlrequestnode.getAttribute("Command"),conf->GetCommandSetAutoAdjustModeKey().data())==0)
		{
			list <DataParameter *> pars;
			XMLNode autoadjustnode = controlrequestnode.getChildNode("AutoAdjust_Mode");
			bool autoadjust;
			if (strcmp(autoadjustnode.getText(),"true")==0)
				autoadjust = true;
			else
				autoadjust = false;
			pars.push_back(new DataBool(autoadjust));
			return new DataControlRequest(response, pars, conf->GetCommandSetAutoAdjustModeKey());
		}
		else
		{
			DataRequest *dr=0;
			return dr;
		}
	}
}

list<DataRequest *> SimulationEngineEncoderDecoder::DecodeMessage(string message)
{
	list <DataRequest *>reqs;
	XMLNode xMainNode=XMLNode::parseString(message.data()); //<Simulation_Message>
	int childnumber=0;
		
	while (!xMainNode.getChildNode(childnumber).isEmpty())
	{
		XMLNode request = xMainNode.getChildNode(childnumber);
		DataRequest *req=0;
		if (strcmp(request.getName(),"Entity_Request")==0)
		{
			req = DecodeEntity(request);
		}
		else if (strcmp(request.getName(),"Control_Request")==0)
		{ 
			req = DecodeControl(request);
		}
		if (req!=0)
			reqs.push_back(req);
		childnumber++;
	}
	xMainNode.deleteNodeContent();
	return reqs;
}

string SimulationEngineEncoderDecoder::EncodeMessage(list<DataParameter *> pars)
{
	string toreturn = "<Response>";
	if (!pars.empty())
	{
		DataString *datastring = (DataString *)(pars.front());
		toreturn += datastring->GetValue();
	}
	toreturn += "</Response>";
	return toreturn;
	
}

}
